import QtQuick 2.12
import QtQuick.Window 2.12
import QtQml 2.12
import "MedComponents"
import "Screens"

Window {
    visible: true
    width: 800
    height: 480
    title: qsTr("Medish Demo")

    Rectangle {
        id: headerBar
        anchors {
            top: parent.top
            left: parent.left; right: parent.right
        }
        height: parent.height * 0.08
        z: 10
        DateTimeLabel { anchors.fill: parent }
    }

    Rectangle {
        id: mainContent
        anchors{ top: headerBar.bottom; bottom: parent.bottom; left: parent.left; right: parent.right }
        color: "cyan"
        Loader {
            id: screenLoader
            anchors.fill: parent
            source: "Screens/HomeScreen.qml"
        }

        Connections {
            target: screenLoader.item
            onRequestRemove: dataModel.removeRow(row)
            onRequestSettings: screenLoader.source = "Screens/SettingScreen.qml"
            onRequestNew: screenLoader.source = "Screens/NewPatientScreen.qml"
            onRequestBack: screenLoader.source = "Screens/HomeScreen.qml"
            onRequestView: {
                screenLoader.source = "Screens/DetailScreen.qml"
                screenLoader.item.index = row
            }
            onRequestEdit: {
                screenLoader.source = "Screens/NewPatientScreen.qml"
                screenLoader.item.index = row
            }
        }
    }
}
